<?php $__env->startSection('title', 'Edit Jadwal Salat'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Edit Jadwal Salat</h2>
    <a href="<?php echo e(route('admin.prayers.index')); ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('admin.prayers.update', $schedule->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label for="city" class="form-label">Kota</label>
                <input type="text" name="city" id="city" class="form-control" value="<?php echo e(old('city', $schedule->city)); ?>" required>
            </div>

            <div class="mb-3">
                <label for="date" class="form-label">Tanggal</label>
                <input type="date" name="date" id="date" class="form-control" value="<?php echo e(old('date', $schedule->date)); ?>" required>
            </div>

            <div class="row">
                <?php $__currentLoopData = ['fajr' => 'Subuh', 'dhuhr' => 'Dzuhur', 'asr' => 'Ashar', 'maghrib' => 'Maghrib', 'isha' => 'Isya']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 mb-3">
                        <label for="<?php echo e($field); ?>" class="form-label"><?php echo e($label); ?></label>
                        <input type="text" name="<?php echo e($field); ?>" id="<?php echo e($field); ?>" class="form-control" 
                               value="<?php echo e(old($field, $schedule->$field)); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="<?php echo e(route('admin.prayers.index')); ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle"></i> Batal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Update
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/prayers/edit.blade.php ENDPATH**/ ?>