<?php $__env->startSection('title', 'Berita - Masjid An Nahl<'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
        <div class="container">
            <div class="text-center text-white">
                <h1 class="display-4 fw-bold mb-3">Berita & Artikel</h1>
                <p class="lead mb-0">Update kabar terbaru komunitas & konten islami dari Masjid An Nahl</p>
            </div>
        </div>
    </section>

    <!-- News Section -->
    <section class="section-padding">
        <div class="container">
            <?php if($news->count() > 0): ?>
                <div class="row g-4">
                    <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="card card-custom h-100">
                                <?php if($item->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $item->image)); ?>" class="card-img-top" alt="<?php echo e($item->title); ?>"
                                        style="height: 220px; object-fit: cover;">
                                <?php else: ?>
                                    <div style="height: 220px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);"></div>
                                <?php endif; ?>

                                <div class="card-body d-flex flex-column">
                                    <div class="mb-2">
                                        <small class="text-muted">
                                            <i class="bi bi-calendar3"></i>
                                            <?php echo e($item->published_date->format('d F Y')); ?>

                                        </small>
                                    </div>

                                    <h5 class="card-title"><?php echo e($item->title); ?></h5>
                                    <p class="card-text text-muted flex-grow-1"><?php echo Str::limit($item->excerpt, 200); ?></p>

                                    <a href="<?php echo e(route('berita.detail', $item->id)); ?>" class="btn btn-outline-primary btn-sm mt-3">
                                        Baca Selengkapnya <i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Pagination -->
                <div class="mt-5 d-flex justify-content-center">
                    <?php echo e($news->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-newspaper display-1 text-muted mb-3"></i>
                    <h3>Belum Ada Berita</h3>
                    <p class="text-muted">Berita akan segera diperbarui. Pantau terus halaman ini!</p>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/berita.blade.php ENDPATH**/ ?>