<?php $__env->startSection('title', 'Edit Profil Masjid'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Edit Profil Masjid</h2>
        <a href="<?php echo e(route('admin.profile.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-1"></i> Kembali
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <div class="d-flex align-items-center">
                <i class="bi bi-check-circle-fill me-2"></i>
                <div><?php echo e(session('success')); ?></div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <div class="d-flex align-items-center">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <div>Terdapat kesalahan dalam pengisian form. Silakan periksa kembali.</div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm border-0">
        <div class="card-body p-4">

            <!-- Tentang Masjid -->
            <div id="tentang-section">
                <form action="<?php echo e(route('admin.profile.update.tentang')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.tentang', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>

            <!-- Divider -->
            <div class="border-top my-5"></div>

            <!-- Visi & Misi -->
            <div id="visimisi-section">
                <form action="<?php echo e(route('admin.profile.update.visimisi')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.visimisi', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>

            <!-- Divider -->
            <div class="border-top my-5"></div>

            <!-- Statistik Masjid -->
            <div id="statistik-section">
                <form action="<?php echo e(route('admin.profile.update.statistik')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.statistik', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>

            <!-- Divider -->
            <div class="border-top my-5"></div>


            <!-- Kontak -->
            <div id="kontak-section">
                <form action="<?php echo e(route('admin.profile.update.kontak')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.kontak', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>

            <!-- Divider -->
            <div class="border-top my-5"></div>

            <!-- Lokasi & Maps -->
            <div id="lokasi-section">
                <form action="<?php echo e(route('admin.profile.update.lokasi')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.lokasi', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>

            <!-- Divider -->
            <div class="border-top my-5"></div>

            <!-- Fasilitas -->
            <div id="fasilitas-section">
                <form action="<?php echo e(route('admin.profile.update.fasilitas')); ?>" method="POST" id="facilities-form">
                    <?php echo csrf_field(); ?>
                    <?php echo $__env->make('admin.profile.parts.fasilitas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.profile.parts.submit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </form>
            </div>
        </div>
    </div>

    <!-- JavaScript untuk fasilitas -->
    <?php $__env->startPush('scripts'); ?>
        <?php echo app('Illuminate\Foundation\Vite')('resources/js/admin/profile/facilities.js'); ?>
    <?php $__env->stopPush(); ?>

    <!-- Smooth Scroll Script -->
    <?php $__env->startPush('scripts'); ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Jika URL ada hash (#section), scroll ke section tersebut
        if (window.location.hash) {
            const hash = window.location.hash;
            const target = document.querySelector(hash);
            
            if (target) {
                // Tunggu sebentar agar DOM fully loaded
                setTimeout(() => {
                    // Smooth scroll ke element
                    target.scrollIntoView({ 
                        behavior: 'smooth',
                        block: 'start'
                    });
                    
                    // Tambah highlight visual
                    const originalBorder = target.style.border;
                    target.style.transition = 'all 0.5s ease';
                    target.style.border = '3px solid rgba(59, 130, 246, 0.3)';
                    target.style.borderRadius = '10px';
                    target.style.padding = '15px';
                    target.style.margin = '-15px';
                    target.style.backgroundColor = 'rgba(59, 130, 246, 0.05)';
                    
                    // Hilangkan highlight setelah 2 detik
                    setTimeout(() => {
                        target.style.border = originalBorder;
                        target.style.padding = '';
                        target.style.margin = '';
                        target.style.backgroundColor = '';
                    }, 2000);
                    
                }, 300);
            }
        }
    });
    </script>
    <?php $__env->stopPush(); ?>

    <!-- CSS only for this edit profile -->
    <?php $__env->startPush('styles'); ?>
        <?php echo app('Illuminate\Foundation\Vite')('resources/css/admin/profile/edit.css'); ?>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/profile/edit.blade.php ENDPATH**/ ?>