<?php $__env->startSection('title', 'Edit Galeri'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Edit Galeri</h2>
    <a href="<?php echo e(route('admin.galleries.index')); ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('admin.galleries.update', $gallery->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label for="title" class="form-label">Judul Galeri <span class="text-danger">*</span></label>
                <input 
                    type="text" 
                    class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    id="title" 
                    name="title" 
                    value="<?php echo e(old('title', $gallery->title)); ?>"
                    required
                >
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3">
                <label class="form-label">Media Saat Ini</label>
                <?php
                    $media = $gallery->image ?? $gallery->video;
                    $ext = strtolower(pathinfo($media, PATHINFO_EXTENSION));
                    
                    $isImage = in_array($ext, ['jpg','jpeg','png','gif','webp']);
                    $isVideo = in_array($ext, ['mp4','mov','avi','mkv','webm']);
                    
                    // Fix untuk path video yang tidak lengkap
                    $videoPath = $gallery->video;
                    if ($videoPath && !str_contains($videoPath, '/')) {
                        $videoPath = 'galleries/videos/' . $videoPath;
                    }
                    
                    $imagePath = $gallery->image;
                    if ($imagePath && !str_contains($imagePath, '/')) {
                        $imagePath = 'galleries/images/' . $imagePath;
                    }
                ?>

                <div class="card" style="max-width: 500px;">
                    <div class="ratio ratio-16x9" style="background: #f8f9fa; overflow:hidden; border-radius: .5rem .5rem 0 0;">
                        <?php if($isImage && $gallery->image): ?>
                            <img 
                                src="<?php echo e(Storage::url($imagePath)); ?>" 
                                alt="<?php echo e($gallery->title); ?>"
                                style="object-fit: cover;" 
                                class="w-100 h-100"
                                onerror="this.parentElement.innerHTML='<div class=\'d-flex justify-content-center align-items-center w-100 h-100 bg-light\'><i class=\'bi bi-image-fill text-muted\' style=\'font-size: 3rem;\'></i></div>'"
                            >
                        
                        <?php elseif($isVideo && $gallery->video): ?>
                            <video 
                                controls
                                preload="metadata"
                                class="w-100 h-100"
                                style="object-fit: contain; background: #000;"
                                playsinline
                            >
                                <source src="<?php echo e(Storage::url($videoPath)); ?>" type="video/mp4">
                                Browser Anda tidak mendukung video ini.
                            </video>
                        
                        <?php else: ?>
                            <div class="d-flex justify-content-center align-items-center w-100 h-100 bg-light">
                                <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="card-body">
                        <?php if($isVideo): ?>
                            <span class="badge bg-primary">
                                <i class="bi bi-camera-video"></i> Video
                            </span>
                        <?php elseif($isImage): ?>
                            <span class="badge bg-success">
                                <i class="bi bi-image"></i> Foto
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="image" class="form-label">Upload Gambar Baru (Opsional)</label>
                <input 
                    type="file" 
                    class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    id="image" 
                    name="image"
                    accept="image/*"
                    onchange="previewImage(event)"
                >
                <small class="text-muted">Format: JPG, PNG, GIF. Max 2MB</small>
                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                
                <div id="imagePreview" class="mt-2" style="display:none;">
                    <label class="form-label">Preview Gambar Baru:</label>
                    <div class="card" style="max-width: 500px;">
                        <img id="previewImg" src="" class="card-img-top" style="object-fit: cover; max-height: 300px;">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="video" class="form-label">Upload Video Baru (Opsional)</label>
                <input 
                    type="file" 
                    class="form-control <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    id="video" 
                    name="video"
                    accept="video/*"
                    onchange="previewVideo(event)"
                >
                <small class="text-muted">Format: MP4, AVI, MOV. Max 50MB</small>
                <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                
                <div id="videoPreview" class="mt-2" style="display:none;">
                    <label class="form-label">Preview Video Baru:</label>
                    <div class="card" style="max-width: 500px;">
                        <video id="previewVid" controls class="card-img-top" style="max-height: 300px; background: #000;"></video>
                    </div>
                </div>
            </div>

            <div class="alert alert-info">
                <i class="bi bi-info-circle"></i>
                <strong>Catatan:</strong> Jika Anda upload gambar/video baru, media lama akan otomatis terhapus.
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-warning">
                    <i class="bi bi-save"></i> Update Galeri
                </button>
                <a href="<?php echo e(route('admin.galleries.index')); ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('previewImg').src = e.target.result;
            document.getElementById('imagePreview').style.display = 'block';
            document.getElementById('videoPreview').style.display = 'none';
        }
        reader.readAsDataURL(file);
    }
}

function previewVideo(event) {
    const file = event.target.files[0];
    if (file) {
        const url = URL.createObjectURL(file);
        document.getElementById('previewVid').src = url;
        document.getElementById('videoPreview').style.display = 'block';
        document.getElementById('imagePreview').style.display = 'none';
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/galleries/edit.blade.php ENDPATH**/ ?>