<?php $__env->startSection('title', 'Jadwal Sholat - Tema Islami'); ?>

<?php $__env->startSection('content'); ?>
<style>
    body {
        background: url('https://images.unsplash.com/photo-1562004760-aceed7bb0dcd?auto=format&fit=crop&w=1350&q=80') center/cover no-repeat;
    }
    .overlay {
        background-color: rgba(0,0,0,0.6);
        padding: 80px 0;
        color: white;
    }
    .card-custom {
        backdrop-filter: blur(10px);
        background-color: rgba(255,255,255,0.15);
        border: 1px solid rgba(255,255,255,0.2);
        border-radius: 1rem;
        color: white;
    }
</style>

<div class="overlay text-center">
    <h1 class="fw-bold mb-2">🕌 Jadwal Sholat</h1>
    <p><?php echo e($prayerTime->location ?? '-'); ?></p>
</div>

<?php if($prayerTime): ?>
<div class="container py-5">
    <div class="row g-4 justify-content-center">
        <?php $__currentLoopData = [
            'Imsak' => $prayerTime->imsak,
            'Subuh' => $prayerTime->subuh,
            'Dzuhur' => $prayerTime->dzuhur,
            'Ashar' => $prayerTime->ashar,
            'Maghrib' => $prayerTime->maghrib,
            'Isya' => $prayerTime->isya
        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card card-custom text-center p-3">
                <h6><?php echo e($name); ?></h6>
                <h3 class="fw-bold"><?php echo e($time); ?></h3>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="text-center mt-5">
        <button class="btn btn-light px-4 py-2" onclick="playAzan()">🔔 Putar Suara Azan</button>
        <audio id="azanAudio" src="https://download.quranicaudio.com/quran/azan/azan1.mp3"></audio>
    </div>
</div>

<script>
    function playAzan() {
        document.getElementById('azanAudio').play();
    }
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/jadwal-islami.blade.php ENDPATH**/ ?>