<?php $__env->startSection('title', 'Kelola Jadwal Salat'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Kelola Jadwal Salat</h2>
    <a href="<?php echo e(route('admin.prayers.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Tambah Jadwal
    </a>
</div>

<form action="<?php echo e(route('admin.prayers.refresh')); ?>" method="POST" class="d-inline">
    <?php echo csrf_field(); ?>
    <button type="submit" class="btn btn-sm btn-warning">
        <i class="bi bi-arrow-repeat"></i> Refresh Otomatis
    </button>
</form>

<div class="card">
    <div class="card-body">
        <?php if($schedules->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kota</th>
                            <th>Tanggal</th>
                            <th>Subuh</th>
                            <th>Dzuhur</th>
                            <th>Ashar</th>
                            <th>Maghrib</th>
                            <th>Isya</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($schedules->firstItem() + $index); ?></td>
                                <td><?php echo e($schedule->city); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($schedule->date)->format('d M Y')); ?></td>
                                <td><?php echo e($schedule->fajr); ?></td>
                                <td><?php echo e($schedule->dhuhr); ?></td>
                                <td><?php echo e($schedule->asr); ?></td>
                                <td><?php echo e($schedule->maghrib); ?></td>
                                <td><?php echo e($schedule->isha); ?></td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.prayers.edit', $schedule->id)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.prayers.destroy', $schedule->id)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('Yakin ingin menghapus jadwal ini?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" title="Hapus">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center mt-4">
                <?php echo e($schedules->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; color: #cbd5e1;"></i>
                <h5 class="mt-3 text-muted">Belum Ada Jadwal Salat</h5>
                <p class="text-muted">Klik tombol "Tambah Jadwal" untuk menambah data baru</p>
                <a href="<?php echo e(route('admin.prayers.create')); ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle"></i> Tambah Jadwal
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/prayers/index.blade.php ENDPATH**/ ?>