<?php $__env->startSection('title', 'Kelola Galeri'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Kelola Galeri</h2>
    <a href="<?php echo e(route('admin.galleries.create')); ?>" class="btn btn-warning">
        <i class="bi bi-plus-circle"></i> Tambah Galeri
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($galleries->count() > 0): ?>
            <div class="row g-3">

                <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3">
                    <div class="card shadow-sm border-0 h-100">

                        <?php
                            $media = $gallery->image ?? $gallery->video;
                            $ext = strtolower(pathinfo($media, PATHINFO_EXTENSION));

                            $isImage = in_array($ext, ['jpg','jpeg','png','gif','webp']);
                            $isVideo = in_array($ext, ['mp4','mov','avi','mkv','webm']);
                            
                            // Fix untuk path video yang tidak lengkap
                            $videoPath = $gallery->video;
                            if ($videoPath && !str_contains($videoPath, '/')) {
                                // Jika hanya nama file tanpa folder, tambahkan path default
                                $videoPath = 'galleries/videos/' . $videoPath;
                            }
                        ?>

                        <div class="ratio ratio-16x9 position-relative" style="background: #f8f9fa; overflow:hidden; border-radius: .5rem .5rem 0 0;">
                            <?php if($isImage && $gallery->image): ?>
                                <img 
                                    src="<?php echo e(Storage::url($gallery->image)); ?>" 
                                    alt="<?php echo e($gallery->title); ?>"
                                    style="object-fit: cover;" 
                                    class="w-100 h-100"
                                    onerror="this.parentElement.innerHTML='<div class=\'d-flex justify-content-center align-items-center w-100 h-100 bg-light\'><i class=\'bi bi-image-fill text-muted\' style=\'font-size: 3rem;\'></i></div>'"
                                >
                            
                            <?php elseif($isVideo && $gallery->video): ?>
                                <video 
                                    controls
                                    preload="metadata"
                                    class="w-100 h-100"
                                    style="object-fit: contain; background: #000;"
                                    playsinline
                                >
                                    <source src="<?php echo e(Storage::url($videoPath)); ?>" type="video/mp4">
                                    Browser Anda tidak mendukung video ini.
                                </video>
                            
                            <?php else: ?>
                                <div class="d-flex justify-content-center align-items-center w-100 h-100 bg-light">
                                    <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card-body">
                            <h6 class="card-title text-truncate" title="<?php echo e($gallery->title); ?>">
                                <?php echo e($gallery->title); ?>

                            </h6>
                            <small class="text-muted">
                                <i class="bi bi-calendar3"></i>
                                <?php echo e($gallery->created_at->format('d M Y')); ?>

                            </small>
                            
                            <?php if($isVideo): ?>
                                <div class="mt-2">
                                    <span class="badge bg-primary">
                                        <i class="bi bi-camera-video"></i> Video
                                    </span>
                                </div>
                            <?php elseif($isImage): ?>
                                <div class="mt-2">
                                    <span class="badge bg-success">
                                        <i class="bi bi-image"></i> Foto
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card-footer bg-white border-top">
                            <div class="d-flex gap-2 justify-content-center">
                                <a 
                                    href="<?php echo e(route('admin.galleries.edit', $gallery->id)); ?>" 
                                    class="btn btn-sm btn-warning w-50"
                                >
                                    <i class="bi bi-pencil"></i> Edit
                                </a>

                                <form 
                                    action="<?php echo e(route('admin.galleries.destroy', $gallery->id)); ?>" 
                                    method="POST" 
                                    class="w-50"
                                    onsubmit="return confirm('Yakin ingin menghapus galeri ini?')"
                                >
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger w-100">
                                        <i class="bi bi-trash"></i> Hapus
                                    </button>
                                </form>
                            </div>
                        </div>

                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="d-flex justify-content-center mt-4">
                <?php echo e($galleries->links()); ?>

            </div>

        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; color: #cbd5e1;"></i>
                <h5 class="mt-3 text-muted">Belum Ada Galeri</h5>
                <p class="text-muted">Klik tombol "Tambah Galeri" untuk menambah foto pertama</p>
                <a href="<?php echo e(route('admin.galleries.create')); ?>" class="btn btn-warning mt-2">
                    <i class="bi bi-plus-circle"></i> Tambah Galeri
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>


<style>
    video {
        background-color: #000;
    }
    
    .card:hover {
        transform: translateY(-5px);
        transition: transform 0.2s ease;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/galleries/index.blade.php ENDPATH**/ ?>