<?php $__env->startSection('title', 'Kelola Kegiatan'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Kelola Kegiatan</h2>
    <a href="<?php echo e(route('admin.activities.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Tambah Kegiatan
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($activities->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="25%">Judul</th>
                            <th width="20%">Tanggal</th>
                            <th width="20%">Tempat</th>
                            <th width="15%">Jenis</th>
                            <th width="15%" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($activities->firstItem() + $index); ?></td>
                                <td>
                                    <strong><?php echo e($activity->title); ?></strong>
                                    <br>
                                    <small class="text-muted"><?php echo e(Str::limit($activity->description, 50)); ?></small>
                                </td>
                                <td>
                                    <i class="bi bi-calendar3 text-primary"></i>
                                    <?php echo e(\Carbon\Carbon::parse($activity->date)->format('d M Y')); ?>

                                </td>
                                <td>
                                    <i class="bi bi-geo-alt text-success"></i>
                                    <?php echo e($activity->place); ?>

                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($activity->type == 'rutin' ? 'primary' : 'success'); ?>">
                                        <?php echo e(ucfirst($activity->type)); ?>

                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.activities.edit', $activity->id)); ?>" 
                                           class="btn btn-sm btn-warning" 
                                           title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.activities.destroy', $activity->id)); ?>" 
                                              method="POST" 
                                              class="d-inline"
                                              onsubmit="return confirm('Yakin ingin menghapus kegiatan ini?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" 
                                                    class="btn btn-sm btn-danger" 
                                                    title="Hapus">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($activities->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-inbox" style="font-size: 4rem; color: #cbd5e1;"></i>
                <h5 class="mt-3 text-muted">Belum Ada Kegiatan</h5>
                <p class="text-muted">Klik tombol "Tambah Kegiatan" untuk menambah data pertama</p>
                <a href="<?php echo e(route('admin.activities.create')); ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle"></i> Tambah Kegiatan
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/admin/activities/index.blade.php ENDPATH**/ ?>