<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h1 class="mb-3"><?php echo e($newsItem->title); ?></h1>

    <p class="text-muted">
        <i class="bi bi-calendar3"></i>
        <?php echo e(\Carbon\Carbon::parse($newsItem->published_date)->format('d F Y')); ?>

    </p>

    <?php if($newsItem->image): ?>
        <img src="<?php echo e(asset('storage/' . $newsItem->image)); ?>" alt="<?php echo e($newsItem->title); ?>" class="img-fluid mb-4 rounded">
    <?php endif; ?>

    <p><?php echo $newsItem->content; ?></p>

    <hr>
    <h4 class="mt-5">Berita Lainnya</h4>
    <div class="row">
        <?php $__currentLoopData = $recentNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-3">
                <div class="card h-100">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($item->title); ?></h5>
                        <small class="text-muted">
                            <?php echo e(\Carbon\Carbon::parse($item->published_date)->format('d F Y')); ?>

                        </small>
                        <p class="card-text mt-2"><?php echo Str::limit($item->excerpt, 200); ?></p>
                        <a href="<?php echo e(route('berita.detail', $item->id)); ?>" class="btn btn-outline-primary btn-sm">
                            Baca Selengkapnya
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/news/detail.blade.php ENDPATH**/ ?>