<?php $__env->startSection('title', 'Beranda - Masjid An Nahl'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Carousel -->
    <div id="heroCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2"></button>
        </div>

        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="/storage/temporary/annahl01a.webp"
                    alt="Masjid 1">
                <div class="carousel-caption px-2 px-sm-3 px-md-4">
                    <h2 class="display-7 fw-bold">Assalamu'alaikum</h2>
                    <p class="lead d-sm-block">Selamat datang di Website Mesjid An Nahl Al Mubarokah</p>
                    <div class="mt-3 mt-md-4">
                        <a href="<?php echo e(route('jadwal')); ?>" class="btn btn-emerald me-2 mb-2">
                            <i class="bi bi-clock"></i> Lihat Jadwal Sholat
                        </a>
                        <a href="<?php echo e(route('donasi')); ?>" class="btn btn-light mb-2">
                            <i class="bi bi-heart"></i> Infaq
                        </a>
                    </div>
                </div>
            </div>
            <div class="carousel-item">
                <img src="/storage/temporary/annahl02.webp" class="d-block w-100"
                    alt="Masjid 2">
                <div class="carousel-caption">
                    <h2 class="display-7 fw-bold">Tempat Ibadah dan Pusat Kegiatan Sosial</h2>
                    <p class="lead">Bersama membangun spiritualitas dan nilai-nilai sosial yang seimbang</p>
                </div>
            </div>
            <div class="carousel-item">
                <img src="/storage/temporary/annahl04.jpg" class="d-block w-100"
                    alt="Masjid 3">
                <div class="carousel-caption">
                    <h2 class="display-7 fw-bold">Mari Memakmurkan Masjid</h2>
                    <p class="lead">Menghidupkan masjid dengan aktivitas ibadah dan kegiatan sosial</p>
                </div>
            </div>
        </div>

        <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
        </button>
    </div>

    <!-- Jadwal Sholat Section
    <?php if(isset($prayerTime)): ?>
        <div class="container my-5">
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <h3 class="fw-bold mb-3">🕋 Jadwal Sholat Hari Ini</h3>
                    <p class="text-muted"><?php echo e($prayerTime->location); ?> | <?php echo e($prayerTime->date); ?></p>
                    <div class="row justify-content-center">
                        <p>Imsak: <?php echo e($todayPrayer->imsak ?? '-'); ?></p>
                        <p>Subuh: <?php echo e($todayPrayer->fajr ?? '-'); ?></p>
                        <p>Dzuhur: <?php echo e($todayPrayer->dhuhr ?? '-'); ?></p>
                        <p>Ashar: <?php echo e($todayPrayer->asr ?? '-'); ?></p>
                        <p>Maghrib: <?php echo e($todayPrayer->maghrib ?? '-'); ?></p>
                        <p>Isya: <?php echo e($todayPrayer->isha ?? '-'); ?></p>

                    </div>
                </div>
            </div>
        </div> -->
    <?php endif; ?>


    <!-- Kegiatan Section -->
    <section class="section-padding">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Kegiatan dan Event</h2>
                <p class="text-muted">Agenda rutin dan insidental untuk jamaah</p>
            </div>

            <div class="row g-4">
                <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-md-4">
                        <div class="card card-custom h-100">
                            <img src="<?php echo e($activity && $activity->image ? asset('storage/' . $activity->image) : 'https://placehold.co/600x400/667eea/ffffff?text=Aktifitas'); ?>"
                                class="card-img-top" alt="Kegiatan" style="object-fit: cover;"
                                onerror="this.src='https://placehold.co/600x400/667eea/ffffff?text=Gambar+Tidak+Tersedia'">                            
                            <div class="card-body mt-3">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h5 class="card-title"><?php echo e($activity->title); ?></h5>
                                    <span class="badge bg-<?php echo e($activity->type == 'rutin' ? 'primary' : 'warning'); ?>">
                                        <?php echo e(ucfirst($activity->type)); ?>

                                    </span>
                                </div>
                                <p class="card-text text-muted"><?php echo Str::limit($activity->description, 200); ?></p>
                                <div class="mt-3">
                                    <small class="text-muted d-block">
                                        <i class="bi bi-calendar"></i> <?php echo e($activity->date); ?>

                                    </small>
                                    <small class="text-muted d-block">
                                        <i class="bi bi-geo-alt"></i> <?php echo e($activity->place); ?>

                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12">
                        <p class="text-center text-muted">Belum ada kegiatan.</p>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($activities->count() > 0): ?>
                <div class="text-center mt-4">
                    <a href="<?php echo e(route('kegiatan')); ?>" class="btn btn-primary-custom">
                        Lihat Semua Kegiatan <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Berita Section -->
    <section class="section-padding bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Berita dan Artikel</h2>
                <p class="text-muted">Update kabar komunitas dan konten islami</p>
            </div>

            <div class="row g-4">
                <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-md-4">
                        <div class="card card-custom h-100">
                            <?php if($item->image): ?>
                                <img src="<?php echo e(asset('storage/' . $item->image)); ?>" class="card-img-top" alt="<?php echo e($item->title); ?>"
                                    style="height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-gradient-primary"
                                    style="height: 200px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);"></div>
                            <?php endif; ?>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo e($item->title); ?></h5>
                                <p class="card-text text-muted"><?php echo e(Str::limit($item->excerpt, 100)); ?></p>
                                <small class="text-muted"><?php echo e($item->published_date->format('d M Y')); ?></small>
                            </div>
                            <div class="card-footer bg-white border-0">
                                <a href="<?php echo e(route('berita.detail', $item->id)); ?>" class="btn btn-outline-primary btn-sm">
                                    Baca Selengkapnya <i class="bi bi-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12">
                        <p class="text-center text-muted">Belum ada berita.</p>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($news->count() > 0): ?>
                <div class="text-center mt-4">
                    <a href="<?php echo e(route('berita')); ?>" class="btn btn-primary-custom">
                        Lihat Semua Berita <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>

<!-- Galeri Section -->
<section class="section-padding">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Galeri</h2>
            <p class="text-muted">Dokumentasi kegiatan jamaah masjid</p>
        </div>

        <div class="row g-4">
            <?php $__empty_1 = true; $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $media = $gallery->image ?? $gallery->video;
                    $ext = strtolower(pathinfo($media, PATHINFO_EXTENSION));

                    $isImage = in_array($ext, ['jpg','jpeg','png','gif','webp']);
                    $isVideo = in_array($ext, ['mp4','mov','avi','mkv','webm']);

                    // Fix untuk path yang tidak lengkap
                    $videoPath = $gallery->video;
                    if ($videoPath && !str_contains($videoPath, '/')) {
                        $videoPath = 'galleries/videos/' . $videoPath;
                    }

                    $imagePath = $gallery->image;
                    if ($imagePath && !str_contains($imagePath, '/')) {
                        $imagePath = 'galleries/images/' . $imagePath;
                    }
                ?>

                <div class="col-md-3 col-6">
                    <div class="card card-custom h-100 gallery-card-landing">
                        <div class="position-relative" style="height: 200px; overflow: hidden; cursor: pointer;" data-bs-toggle="modal" data-bs-target="#modalGallery<?php echo e($gallery->id); ?>">
                            <?php if($isImage && $gallery->image): ?>
                                <img
                                    src="<?php echo e(Storage::url($imagePath)); ?>"
                                    class="w-100 h-100 gallery-img-landing"
                                    alt="<?php echo e($gallery->title); ?>"
                                    style="object-fit: cover;"
                                    onerror="this.parentElement.innerHTML='<div class=\'d-flex justify-content-center align-items-center w-100 h-100 bg-light\'><i class=\'bi bi-image-fill text-muted\' style=\'font-size: 3rem;\'></i></div>'"
                                >

                                
                                <div class="position-absolute top-0 start-0 w-100 h-100 d-flex justify-content-center align-items-center gallery-overlay-landing">
                                    <i class="bi bi-zoom-in text-white" style="font-size: 2.5rem;"></i>
                                </div>

                            <?php elseif($isVideo && $gallery->video): ?>
                                <video
                                    preload="metadata"
                                    class="w-100 h-100"
                                    style="object-fit: cover; background: #000;"
                                    playsinline
                                >
                                    <source src="<?php echo e(Storage::url($videoPath)); ?>" type="video/mp4">
                                </video>

                                
                                <div class="position-absolute top-50 start-50 translate-middle" style="pointer-events: none;">
                                    <i class="bi bi-play-circle-fill text-white" style="font-size: 3.5rem; opacity: 0.9; text-shadow: 0 2px 8px rgba(0,0,0,0.5);"></i>
                                </div>

                            <?php else: ?>
                                <div class="d-flex justify-content-center align-items-center w-100 h-100 bg-light">
                                    <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card-body">
                            <h5 class="card-title mb-2" style="font-size: 0.95rem;"><?php echo e($gallery->title); ?></h5>
                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <small class="text-muted">
                                    <i class="bi bi-calendar3"></i>
                                    <?php echo e($gallery->created_at->format('d M Y')); ?>

                                </small>

                                <?php if($isVideo): ?>
                                    <span class="badge bg-primary">
                                        <i class="bi bi-camera-video"></i> Video
                                    </span>
                                <?php elseif($isImage): ?>
                                    <span class="badge bg-success">
                                        <i class="bi bi-image"></i> Foto
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="modal fade" id="modalGallery<?php echo e($gallery->id); ?>" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <p class="modal-title"><?php echo e($gallery->title); ?></p>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body p-0">
                                <?php if($isImage && $gallery->image): ?>
                                    <img
                                        src="<?php echo e(Storage::url($imagePath)); ?>"
                                        alt="<?php echo e($gallery->title); ?>"
                                        class="w-100"
                                        style="object-fit: contain; max-height: 80vh;"
                                    >
                                <?php elseif($isVideo && $gallery->video): ?>
                                    <video
                                        controls
                                        class="w-100"
                                        style="background: #000; max-height: 80vh;"
                                        playsinline
                                    >
                                        <source src="<?php echo e(Storage::url($videoPath)); ?>" type="video/mp4">
                                        Browser Anda tidak mendukung video ini.
                                    </video>
                                <?php endif; ?>
                            </div>
                            <div class="modal-footer">
                                <small class="text-muted me-auto">
                                    <i class="bi bi-calendar3"></i>
                                    <?php echo e($gallery->created_at->format('d F Y, H:i')); ?>

                                </small>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <p class="text-center text-muted">Belum ada galeri.</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if($galleries->count() > 0): ?>
            <div class="text-center mt-4">
                <a href="<?php echo e(route('galeri')); ?>" class="btn btn-primary-custom">
                    Lihat Semua Galeri <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>


<style>
.gallery-card-landing {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.gallery-card-landing:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.12) !important;
}

.gallery-img-landing {
    transition: transform 0.3s ease;
}

.gallery-card-landing:hover .gallery-img-landing {
    transform: scale(1.05);
}

.gallery-overlay-landing {
    background: rgba(0,0,0,0.5);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.gallery-card-landing:hover .gallery-overlay-landing {
    opacity: 1;
}

.modal-content {
    border-radius: 1rem;
    overflow: hidden;
}
</style>


    <!-- CTA Donasi -->
    <section class="py-5 object-right" style="
        background-image: url('/storage/temporary/infaq.png');
        background-color: #198754;
        background-repeat: no-repeat;
        ">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h3 class="text-white mb-2">Dukung Program Dakwah Masjid</h3>
                    <p class="text-white mb-0">Salurkan infaq terbaik Anda untuk memakmurkan masjid</p>
                </div>
                <div class="col-md-4 text-md-end mt-3 mt-md-0 font-normal">
                    <a href="<?php echo e(route('donasi')); ?>" class="btn btn-light">
                        <i class="bi bi-heart-fill" style="color:#198754"></i> Infaq Sekarang
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/annahl/resources/views/home.blade.php ENDPATH**/ ?>